/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.operands.ByteOperand;
import emulator.support.AbsoluteOperandEval;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class Absolute
extends ByteOperand {
    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        super.init(cpu);
        this.setAddress(new HwWord((long)cpu.fetchProgramWord()));
    }

    @Override
    public String getString() {
        return "$" + this.getAddress();
    }

    @Override
    public int getByteCount() {
        return 2;
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return symbols.getLabelOrAddress(mem_ref.getWordOp());
    }

    @Override
    public int getExtraCycles() {
        return 2;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new AbsoluteOperandEval(mem_ref);
    }
}

